<?php

namespace App\Http\Controllers;

use App\Models\Release;
use App\Http\Requests\StoreReleaseRequest;
use App\Http\Requests\UpdateReleaseRequest;

use App\Models\Artist;
use App\Models\Country;
use App\Models\Dsp;
use App\Models\Genre;
use App\Models\SubGenre;
use App\Models\Track;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Models\Upc;
use App\Models\UPCS;
use App\Models\User;
use DB;
use Hash;
use Illuminate\Support\Arr;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;

class ReleaseController extends Controller
{
    public function __construct()
    {

        $this->middleware('auth');
        $this->middleware('permission:view-release|create-release|edit-release|delete-release', ['only' => ['index', 'show']]);
        $this->middleware('permission:create-release', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit-release', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete-release', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        user_logs();
        $data = Release::latest()->paginate(itemsPerPage());
        return view('releases.index', compact('data'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    public function getReleaseSubLabelsofLabels(Request $request)
    {
        $label_id = $request->input('label_id');
        if (empty($label_id)) {
            return  '<div class="form-group main-form">
            <label class="form-label required" for="language">Sub Label
                <i class="fa-solid fa-circle-info">
            </i></label>
            <select name="sublabel_id" id="sublabel_id" class="form-control">
                <option value="">Select Sub Label</option></select>
            </div>';
        }
        $users = User::where('parent_id', $label_id)->get();
        $select = '<div class="form-group main-form">
            <label class="form-label required" for="language">Sub Label
                <i class="fa-solid fa-circle-info">
            </i></label>
            <select name="sublabel_id" id="sublabel_id" class="form-control">
                <option value="">Select Sub Label</option>';

        $options = '';
        foreach ($users as $user) {
            $options .= '<option value="' . $user->id . '">' . $user->name . '</option>';
        }
        return $select . $options . '</select>
            </div>';
    }


    public function uploadReleaseSingleLyrics(Request $request)
    {
        $input = $request->all();
        return response()->json(['message' => 'File uploaded successfully!', 'path' => '']);
        // echo '<pre>';print_r($input);echo '</pre>';
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // Session::forget('release_form_show');
        user_logs();
        $artists = Artist::get();
        $subLablesRole = Role::with('users')->where('id', Role::SUBLABEL)->first();
        $subLablesUsers = $subLablesRole->users;
        $lablesRole = Role::with('users')->where('id', Role::LABEL)->first();
        $lablesUsers = $lablesRole->users;
        $genres = Genre::where('status', Genre::ACTIVE)->get();
        return view('releases.create', compact('artists', 'subLablesUsers', 'lablesUsers', 'genres'));
    }

    public function getReleaseSubGenre(Request $request)
    {

        $genre_id = $request->input('genre_id');
        $track = $request->input('track') ?? false;
        $subGenres = SubGenre::where([['genre_id', '=', $genre_id], ['status', '=', SubGenre::ACTIVE]])->get();

        $options = null;
        foreach ($subGenres as $subGenre) {
            $options .= '<option value="' . $subGenre->id . '">' . $subGenre->title . '</option>';
        }

        if ($track) {
            return '<div class="form-group single-artist">
                    <label class="form-label required" for="subGenre">Sub Genre</label>
                    <select name="subgenre_id" id="subgenre_id" class="form-control" required>
                    <option value="">Select Sub Genre</option>
                    ' . $options . '
                </select>
                </div>';
        }

        return '<div class="form-group main-form">
                <label class="form-label required" for="sub_genre">Sub Genre<i class="fa-solid fa-circle-info"></i></label>
                <select name="subgenre_id" id="subgenre_id" class="form-control" required>
                    <option value="">Select Sub Genre</option>
                    ' . $options . '
                    </select>
              </div>';
    }


    public function releaseTrackDelete(Request $request)
    {
        $track_id = $request->input('track_id');
        $release_id = $request->input('release_id');
        $release = Release::find($release_id);
        if (!empty($release)) {
            $track = Track::find($track_id);
            if (!empty($track)) {
                if (!empty($track->audio_files)) {
                    $trackAudios = json_decode($track->audio_files);
                    foreach ($trackAudios as $trackAudio) {
                        Storage::disk('public')->delete($trackAudio);
                    }
                }
                $track->delete();
                return redirect()->route('release.edit', $release_id)->with([
                    'message' => 'Release track deleted successfully',
                    'alert-type' => 'success'
                ]);
            } else {
                return redirect()->route('release.edit', $release_id)->with([
                    'message' => 'Invalid Track',
                    'alert-type' => 'error'
                ]);
            }
        } else {
            return redirect()->route('release.index')->with([
                'message' => 'Invalid Release!',
                'alert-type' => 'error'
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreReleaseRequest $request)
    {
        user_logs();
        $input = $request->all();
        $isrc_number = $input['isrc'] ?? '';
        unset($input['isrc']);

        $sessionData = Session::get('release_labels');
        if (!empty($sessionData)) {
            $input['label_id'] = $sessionData['lable'];
            $input['sublabel_id'] = $sessionData['sublabel'];
        }

        $input['created_by'] = Auth::user()->id;
        $input['updated_by'] = Auth::user()->id;

        $user = Auth::user();
        $userRoles = '';
        if ($user && $user->roles->isNotEmpty()) {
            $role = $user->roles->first();
            $userRoles = $role->name;
        }

        $input['created_by_user_role'] = $userRoles;
        $input['updated_by_user_role'] = $userRoles;

        // Save display blank for now
        $input['display_artist'] = null;



        // $input['c_line_year'] =  $input['c_line_year'];
        // echo '<pre>';print_r($input);echo '</pre>';die();
        // if (!empty($input['upc_number'])) {
        //     $upcNumberStatus = false;
        //     $upcnumber = $input['upc_number'];
        //     $upcCount = UPCS::where([
        //         ['status', '=', UPCS::NEW],
        //         ['upc', '=', $upcnumber]
        //     ])->count();

        //     $eanCount = UPCS::where([
        //         ['status', '=', UPCS::NEW],
        //         ['ean', '=', $upcnumber]
        //     ])->count();
        // }

        $release = Release::create($input);

        /**
         * 
         * Upload releae files
         */

        Session::forget('release_form_show');

        if (!empty($release->id)) {
            $releaseModel = Release::find($release->id);
            $lastReleaseId = $release->id;
            $path = storage_path() . "/releasefiles/$lastReleaseId";
            if (!Storage::exists($path)) {
                File::makeDirectory($path, $mode = 0777, true, true);
            }

            $apple_path = storage_path() . "/releasefiles/apple/$lastReleaseId";
            if (!Storage::exists($apple_path)) {
                File::makeDirectory($apple_path, $mode = 0777, true, true);
            }

            $lyrics_path = storage_path() . "/releasefiles/lyricfile/$lastReleaseId";
            if (!Storage::exists($lyrics_path)) {
                File::makeDirectory($lyrics_path, $mode = 0777, true, true);
            }

            $single_audio_path = storage_path() . "/releasefiles/single_audio/$lastReleaseId";
            if (!Storage::exists($single_audio_path)) {
                File::makeDirectory($single_audio_path, $mode = 0777, true, true);
            }

            if ($request->hasFile('artwork') && $request->file('artwork')->isValid()) {
                $fileSavePath = "releasefiles/$lastReleaseId";
                $artwork = $request->file('artwork');
                $filepath = $artwork->store($fileSavePath, 'public');
                $releaseModel->artwork = $filepath;
            }


            if ($request->hasFile('apple_art') && $request->file('apple_art')->isValid()) {
                $fileSavePath = "releasefiles/apple/$lastReleaseId";
                $apple_art = $request->file('apple_art');
                $applefilepath = $apple_art->store($fileSavePath, 'public');
                $releaseModel->apple_art = $applefilepath;
            }


            if ($request->hasFile('single_release_audio') && $request->file('single_release_audio')->isValid()) {
                $fileSavePath = "releasefiles/single_audio/$lastReleaseId";
                $single_audio_file = $request->file('single_release_audio');
                $single_audio_filepath = $single_audio_file->store($fileSavePath, 'public');
                $releaseModel->single_audio_file = $single_audio_filepath;
                $input['audio_files'] = $single_audio_filepath;
            }


            if ($request->hasFile('singleReleaseLyricFile') && $request->file('singleReleaseLyricFile')->isValid()) {
                $fileSavePath = "releasefiles/lyricfile/$lastReleaseId";
                $lyricfile = $request->file('singleReleaseLyricFile');
                $lyricfilefilepath = $lyricfile->store($fileSavePath, 'public');
                $releaseModel->lyrics_file = $lyricfilefilepath;
            }



            $releaseModel->save();

            if ($release->release_type == "release") {
                $release_id = $release->id;
                $input['release_id'] =  $release_id;
                $input['price'] =  $input['price_tier'];

                if (!empty($input['isrc'])) {
                    $input['have_isrc'] = 1;
                    $input['isrc_number'] = $input['isrc'];
                }

                // echo '<pre>';print_r($input);echo '</pre>';die();

                Track::create($input);
                Session::forget('release_form_show');
                return redirect()->route('release.index')->with([
                    'message' => 'Release created successfully',
                    'alert-type' => 'success'
                ]);
            }

            Session::put('release_step', 2);
            return redirect()->route('release.edit', $release->id)->with([
                'message' => 'Release created successfully',
                'alert-type' => 'success'
            ]);
        }

        return redirect()->route('release.index')->with([
            'message' => 'Release created successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Release $release)
    {
        user_logs();
        $release = Release::find($release->id);
        return view('releases.show', compact('release'));
    }


    public function releaseArtistCreate()
    {
        Session::put('releaseArtistCreate', 1);
        return 'done';
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Release $release)
    {
        user_logs();
        Session::put('release_step', 6);
        $release = Release::find($release->id);
        $artists = Artist::get();
        $roles = Role::where('id', Role::LABEL)->first();
        $users = $roles->users->all();
        $genres = Genre::where('status', Genre::ACTIVE)->get();
        $counteries = Country::where('status', Country::ACTIVE)->get();
        $dsps = Dsp::where('status', Dsp::ACTIVE)->get();
        $tracks = Track::where('release_id', $release->id)->latest()->paginate(50);
        return view('releases.edit', compact('release', 'artists', 'roles', 'users', 'genres', 'tracks', 'counteries', 'dsps'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateReleaseRequest $request, Release $release)
    {
        user_logs();
        $input = $request->all();
        $release = Release::find($release->id);
        $release->update($input);
        Session::put('release_step', 2);

        if (!empty($id)) {
            $releaseModel = Release::find($id);
            $lastReleaseId = $id;
            $path = storage_path() . "/releasefiles/$lastReleaseId";
            if (!Storage::exists($path)) {
                File::makeDirectory($path, $mode = 0777, true, true);
            }

            $apple_path = storage_path() . "/releasefiles/apple/$lastReleaseId";
            if (!Storage::exists($apple_path)) {
                File::makeDirectory($apple_path, $mode = 0777, true, true);
            }

            if ($request->hasFile('artwork') && $request->file('artwork')->isValid()) {
                $fileSavePath = "releasefiles/$lastReleaseId";
                $artwork = $request->file('artwork');
                $filepath = $artwork->store($fileSavePath, 'public');
                $releaseModel->artwork = $filepath;
            }

            if ($request->hasFile('apple_art') && $request->file('apple_art')->isValid()) {
                $fileSavePath = "releasefiles/apple/$lastReleaseId";
                $apple_art = $request->file('apple_art');
                $applefilepath = $apple_art->store($fileSavePath, 'public');
                $releaseModel->apple_art = $applefilepath;
            }

            $releaseModel->save();

            Session::put('release_step', 6);
            return redirect()->route('release.edit', $id)->with([
                'message' => 'Release created successfully',
                'alert-type' => 'success'
            ]);
        }
        return redirect()->route('release.index')->with([
            'message' => 'Release updated successfully',
            'alert-type' => 'success'
        ]);
    }

    public function releaseTrackEdit(Request $request)
    {

        user_logs();
        $input = $request->all();
        $track_id = $input['track_id'];
        $release_id = $input['release_id'];
        $user_id = Auth::user()->id;
        $release = Release::where([
            ['id', '=', $release_id],
            ['created_by', '=', $user_id]
        ])->first();
        if (empty($release)) {
            return response()->json(['error' => 'InvalidRelease'], 400);
        }

        $track = Track::where([
            ['id', '=', $track_id],
            ['release_id', '=', $release_id]
        ])->first();
        if (empty($track)) {
            return response()->json(['error' => 'InvalidTrack'], 400);
        }

        $artists = Artist::get();
        $subLablesRole = Role::with('users')->where('id', Role::SUBLABEL)->first();
        $subLablesUsers = $subLablesRole->users;
        $lablesRole = Role::with('users')->where('id', Role::LABEL)->first();
        $lablesUsers = $lablesRole->users;
        $genres = Genre::where('status', Genre::ACTIVE)->get();


        // Render the Blade view as HTML and return it
        $html = view('releases.edit-track', compact('artists', 'subLablesUsers', 'lablesUsers', 'genres','release','track'))->render();
        return response()->json(['html' => $html]);
        // return view('releases.edit-track', compact('artists', 'subLablesUsers', 'lablesUsers', 'genres'));

    }

    public function releaseTrackUpdateModals(Request $request,$id): RedirectResponse
    {
        user_logs();
        $input = $request->all();
        $track_id = $input['track_id'];
        $track = Track::find($track_id);
        $input['release_id'] = $id;
        $remixer_list = null;
        $remixer = $input['remixer'];
        if (!empty($input['remixer_list'])) {
            $remixer_list = implode(",", $input['remixer_list']);
        }
        $input['remixer'] = $remixer_list . ',' . $remixer;

        if (!empty($input['explicit'])) {
            $input['explicit'] = 1;
        } else {
            $input['explicit'] = 0;
        }

        if (!empty($input['sold_with_album'])) {
            $input['sold_with_album'] = 1;
        } else {
            $input['sold_with_album'] = 0;
        }

        $input['disc'] = 1;

        $input['price'] = $input['price_tier'];

        unset($input['price_tier']);
        unset($input['remixer_list']);
        
        // $track = Track::create($input);
        $track->update($input);

        /**
         * 
         * Upload releae files
         */

        if ($track->id) {
            $lastTrackId = $track->id;
            if (!Storage::exists(storage_path() . "/releasefiles/tracks")) {
                File::makeDirectory(storage_path() . "/releasefiles/tracks", $mode = 0777, true, true);
            }

            if (!Storage::exists(storage_path() . "/releasefiles/tracks/$lastTrackId")) {
                File::makeDirectory(storage_path() . "/releasefiles/tracks/$lastTrackId", $mode = 0777, true, true);
            }

            if ($request->hasFile('my_audio_files') && $request->file('my_audio_files')->isValid()) {
                $fileSavePath = "releasefiles/tracks/$lastTrackId";
                $my_audio_files = $request->file('my_audio_files');
                $singlefilepath = $my_audio_files->store($fileSavePath, 'public');

                $files = [];
                $files[] = $singlefilepath;

                $trackModel = Track::find($lastTrackId);
                $trackModel->audio_files = json_encode($files);
                $trackModel->save();
            }

            Session::put('release_step', 6);
            return redirect()->route('release.edit', $id)->with([
                'message' => 'Release created successfully',
                'alert-type' => 'success'
            ]);
        }


        return redirect()->route('release.index')->with([
            'message' => 'Release updated successfully',
            'alert-type' => 'success'
        ]);
    }





    public function releaseTrackUpdate(Request $request, $id): RedirectResponse
    {
        user_logs();
        // $this->validate($request, [
        //     'composer' => 'required'
        // ]);

        $input = $request->all();
        $input['release_id'] = $id;
        $remixer_list = null;
        $remixer = $input['remixer'];
        if (!empty($input['remixer_list'])) {
            $remixer_list = implode(",", $input['remixer_list']);
        }
        $input['remixer'] = $remixer_list . ',' . $remixer;
        if (!empty($input['explicit'])) {
            $input['explicit'] = 1;
        } else {
            $input['explicit'] = 0;
        }
        if (!empty($input['sold_with_album'])) {
            $input['sold_with_album'] = 1;
        } else {
            $input['sold_with_album'] = 0;
        }
        $input['disc'] = 1;
        $input['price'] = $input['price_tier'];
        unset($input['price_tier']);
        unset($input['remixer_list']);
        $track = Track::create($input);

        /**
         * 
         * Upload releae files
         */

        if ($track->id) {
            $lastTrackId = $track->id;
            if (!Storage::exists(storage_path() . "/releasefiles/tracks")) {
                File::makeDirectory(storage_path() . "/releasefiles/tracks", $mode = 0777, true, true);
            }

            if (!Storage::exists(storage_path() . "/releasefiles/tracks/$lastTrackId")) {
                File::makeDirectory(storage_path() . "/releasefiles/tracks/$lastTrackId", $mode = 0777, true, true);
            }

            if ($request->hasFile('my_audio_files') && $request->file('my_audio_files')->isValid()) {
                $fileSavePath = "releasefiles/tracks/$lastTrackId";
                $my_audio_files = $request->file('my_audio_files');
                $singlefilepath = $my_audio_files->store($fileSavePath, 'public');

                $files = [];
                $files[] = $singlefilepath;

                $trackModel = Track::find($lastTrackId);
                $trackModel->audio_files = json_encode($files);
                $trackModel->save();
            }

            Session::put('release_step', 6);
            return redirect()->route('release.edit', $id)->with([
                'message' => 'Release created successfully',
                'alert-type' => 'success'
            ]);
        }


        return redirect()->route('release.index')->with([
            'message' => 'Release updated successfully',
            'alert-type' => 'success'
        ]);
    }

    public function releaseMultipleTrackUpdate(Request $request, $id): RedirectResponse
    {
        user_logs();
        if (!empty($id)) {
            $releaseModel = Release::find($id);
            if (!empty($releaseModel)) {
                if ($request->hasFile('multipleTrackFiles')) {
                    if (!Storage::exists(storage_path() . "/releasefiles/tracks")) {
                        File::makeDirectory(storage_path() . "/releasefiles/tracks", $mode = 0777, true, true);
                    }
                    foreach ($request->file('multipleTrackFiles') as $audioFile) {
                        $track = Track::create([
                            'release_id' => $releaseModel->id,
                            'artists' => $releaseModel->artists,
                            'display_artist' => $releaseModel->display_artist,
                            'feature_artist' => $releaseModel->feature_artist,
                            'title' => $releaseModel->title,
                            'remixer' => $releaseModel->remixer,
                            'orchestra' => $releaseModel->orchestra,
                            'arranger' => $releaseModel->arranger,
                            'actor' => $releaseModel->actor,
                            'conductor' => $releaseModel->conductor,
                            'composer' => $releaseModel->composer,
                            'genre_id' => $releaseModel->genre_id,
                            'subgenre_id' => $releaseModel->subgenre_id,
                            'have_isrc' => 1,
                            'isrc_number' => $releaseModel->isrc,
                            'price' => $releaseModel->price_tier
                        ]);

                        $lastTrackId = $track->id;
                        if (!Storage::exists(storage_path() . "/releasefiles/tracks/$lastTrackId")) {
                            File::makeDirectory(storage_path() . "/releasefiles/tracks/$lastTrackId", $mode = 0777, true, true);
                        }

                        $fileSavePath = "releasefiles/tracks/$lastTrackId";
                        $filepath = $audioFile->store($fileSavePath, 'public');
                        $files = [];
                        $files[] = $filepath;

                        $trackModel = Track::find($lastTrackId);
                        if (!empty($trackModel)) {
                            $trackModel->audio_files = json_encode($files);
                            $trackModel->save();
                        }
                    }
                    Session::put('release_step', 6);
                    return redirect()->route('release.edit', $id)->with([
                        'message' => 'Release created successfully',
                        'alert-type' => 'success'
                    ]);
                } else {
                    Session::put('release_step', 6);
                    return redirect()->route('release.edit', $id)->with([
                        'message' => 'Plesae select atlease one track!',
                        'alert-type' => 'error'
                    ]);
                }
            } else {
                return redirect()->route('release.index')->with([
                    'message' => 'Invalid Release',
                    'alert-type' => 'error'
                ]);
            }
        } else {
            return redirect()->route('release.index')->with([
                'message' => 'Invalid Release',
                'alert-type' => 'error'
            ]);
        }
    }


    public function releaseLabelsSave(Request $request)
    {
        user_logs();
        $input = $request->all();
        $label = $input['label_id'];
        $sublabel = $input['sublabel_id'];
        if (empty($label)) {
            return redirect()->back()->with([
                'message' => 'Labels Reqquired!',
                'alert-type' => 'error'
            ]);
        }
        Session::put('release_labels', ['lable' => $label, 'sublabel' => $sublabel]);
        Session::put('release_form_show', true);
        return redirect()->back();
    }
    public function releaseLabelsDelete()
    {
        Session::forget('release_form_show');
        return redirect()->back();
    }


    public function releaseTerrioryUpdate(Request $request, $id): RedirectResponse
    {
        user_logs();
        $input = $request->all();

        $countries = json_encode([]);
        if (!empty($input['countries'])) {
            $countries = json_encode($input['countries']);
        }
        $releaseModel = Release::find($id);
        if (!empty($releaseModel)) {
            $releaseModel->country_ids = $countries;
            $releaseModel->save();

            Session::put('release_step', 6);

            return redirect()->route('release.edit', $id)->with([
                'message' => 'Release created successfully',
                'alert-type' => 'success'
            ]);
        } else {

            return redirect()->route('release.index')->with([
                'message' => 'Release updated successfully',
                'alert-type' => 'success'
            ]);
        }
    }

    public function releaseDeliveryUpdate(Request $request, $id): RedirectResponse
    {
        user_logs();
        $input = $request->all();
        $dspsarr = json_encode([]);

        if (!empty($input['dspsarr'])) {
            $dspsarr = json_encode($input['dspsarr']);
        }

        $releaseModel = Release::find($id);
        if (!empty($releaseModel)) {

            $releaseModel->dsp_ids = $dspsarr;
            $releaseModel->save();

            Session::put('release_step', 6);
            return redirect()->route('release.edit', $id)->with([
                'message' => 'Release created successfully',
                'alert-type' => 'success'
            ]);
        } else {
            return redirect()->route('release.index')->with([
                'message' => 'Release updated successfully',
                'alert-type' => 'success'
            ]);
        }
    }

    public function releaseFinishUpdate(Request $request, $id): RedirectResponse
    {
        user_logs();

        $this->validate($request, [
            'agree' => 'required'
        ]);

        $input = $request->all();
        // echo '<pre>';print_r($input);die();
        $relaseModel = Release::find($id);
        if (!empty($relaseModel)) {

            $relaseModel->exclusive_on_shop = $input['exclusive_on_shop'];
            $relaseModel->exclusive_for = $input['exclusive_for'];
            $itunes = 0;
            if (!empty($input['on_itunes'])) {
                $itunes = 1;
            }
            $relaseModel->on_itunes = $itunes;
            $relaseModel->save();

            return redirect()->route('release.index')->with([
                'message' => 'Release updated successfully',
                'alert-type' => 'success'
            ]);
        }
        Session::put('release_step', 6);
        return redirect()->route('release.edit', $id)->with([
            'message' => 'Release created successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Release $release)
    {
        user_logs();
        $releaseModel = Release::find($release->id);

        /**
         * 
         * Delete release artwor and apple art files
         * 
         */

        if (!empty($releaseModel->artwork)) {
            Storage::disk('public')->delete($releaseModel->artwork);
        }

        if (!empty($releaseModel->apple_art)) {
            Storage::disk('public')->delete($releaseModel->apple_art);
        }

        /**
         * 
         * Delete track file related to release 
         * 
         */

        $tracks = Track::where('release_id', $release->id)->get();
        foreach ($tracks as $track) {
            if (!empty($track->audio_files)) {
                $track_files = json_decode($track->audio_files);
                if (!empty($track_files)) {
                    foreach ($track_files as $track_file) {
                        Storage::disk('public')->delete($track_file);
                    }
                }
            }
        }


        /**
         * 
         * Delete tracks related to release
         * 
         */

        Track::where('release_id', $release->id)->delete();


        /**
         * 
         * Delete release
         * 
         */

        $releaseModel->delete();
        return redirect()->route('release.index')->with([
            'message' => 'Release deleted successfully',
            'alert-type' => 'success'
        ]);
    }
}
